<?php
include 'config.php';
include 'admin_header.php';

// --- Fungsi ambil metadata
function getMetaData($url) {
    $context = stream_context_create(['http' => ['timeout' => 5]]);
    @$html = file_get_contents($url, false, $context);
    if (!$html) return [null, null];
    $doc = new DOMDocument();
    @$doc->loadHTML($html);
    $metas = $doc->getElementsByTagName('meta');
    $title = null; $image = null;
    foreach ($metas as $meta) {
        $property = $meta->getAttribute('property');
        $name = $meta->getAttribute('name');
        $content = $meta->getAttribute('content');
        if ($property == 'og:title' || $name == 'title') $title = $content;
        if ($property == 'og:image') $image = $content;
    }
    if (!$title) {
        preg_match("/<title>(.*?)<\/title>/si", $html, $match);
        $title = $match[1] ?? 'Tanpa Judul';
    }
    return [$title, $image];
}

// Simpan berita
if (isset($_POST['link'])) {
    $link = trim($_POST['link']);
    if (!empty($link)) {
        list($judul, $thumbnail) = getMetaData($link);
        $slug = md5(uniqid());
        $stmt = $conn->prepare("INSERT INTO berita (link, judul, thumbnail, slug) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $link, $judul, $thumbnail, $slug);
        $stmt->execute();
        $stmt->close();
        header("Location: admin_input.php");
        exit;
    }
}

// Filter tanggal
if (!empty($_GET['filter_tanggal'])) {
    $filter_tanggal = $_GET['filter_tanggal'];
    $stmt = $conn->prepare("SELECT * FROM berita WHERE DATE(created_at)=? ORDER BY id DESC");
    $stmt->bind_param("s", $filter_tanggal);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    $result = $conn->query("SELECT * FROM berita ORDER BY id DESC");
}

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off'
    || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$baseUrl = $protocol . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/');
?>
<div class="navbar">
    <button class="menu-btn" onclick="toggleMenu()"><i class="bi bi-list"></i></button>
    <h5>📑 Input & Kelola Berita</h5>
</div>

<div class="content">
    <div class="card p-3 mb-4">
        <form method="POST" class="d-flex flex-wrap gap-2">
            <input type="text" name="link" class="form-control flex-grow-1" placeholder="Tempel link berita di sini..." required>
            <button type="submit" class="btn btn-primary"><i class="bi bi-save"></i> Simpan</button>
        </form>
        <form method="GET" class="mt-3 d-flex flex-wrap gap-2">
            <input type="date" name="filter_tanggal" value="<?= htmlspecialchars($_GET['filter_tanggal'] ?? '') ?>" class="form-control" style="max-width:200px;">
            <button type="submit" class="btn btn-secondary"><i class="bi bi-filter"></i> Filter</button>
        </form>
    </div>

    <div class="row g-3">
        <?php if ($result && $result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()):
                $link_view = $baseUrl . "/view.php?slug=" . urlencode($row['slug']);
            ?>
            <div class="col-md-6 col-lg-4">
                <div class="card p-2">
                    <?php if (!empty($row['thumbnail'])): ?>
                        <img src="<?= htmlspecialchars($row['thumbnail']) ?>" class="thumbnail mb-2" alt="thumbnail">
                    <?php endif; ?>
                    <h6><?= htmlspecialchars($row['judul'] ?: 'Tanpa Judul') ?></h6>
                    <small class="text-muted"><?= date('d M Y - H:i', strtotime($row['created_at'])) ?></small>
                    <div class="bg-light p-2 rounded mt-2 d-flex justify-content-between align-items-center">
                        <small class="text-truncate" style="max-width:70%;"><?= $link_view ?></small>
                        <button class="btn btn-success btn-sm" onclick="navigator.clipboard.writeText('<?= $link_view ?>')"><i class="bi bi-clipboard"></i></button>
                    </div>
                </div>
            </div>
            <?php endwhile; else: ?>
            <p class="text-center text-muted mt-4">Tidak ada data berita.</p>
        <?php endif; ?>
    </div>
</div>
